#include "bsp.h"
#include "tty.h"

static char buf[16];
static unsigned char bufp, bufg;
static volatile int bufc;

/* nRTS is the only input */
#define nRTS p6.b5

#define nCTS p6.b0
#define nDSR p6.b1
#define nDCD p6.b2
#define nRI  p6.b4

#if 0
#define STOP()  nCTS = 1, nLED = 0
#define START() nCTS = 0, nLED = 1
#else
#define STOP()
#define START()
#endif

void __attribute__((interrupt))
s1rx_handler ()
{
  buf[bufp&15] = u1rb;
  bufp ++;
  bufc ++;
  if (bufc > 12)
    STOP();
}

void
tty_init ()
{
  START();

  /* Round up */
  u1brg = (CLOCK_HZ + BAUD * 8) / (BAUD * 16) - 1;

  u1mr.b = 5;	/* UART, 8N1 */
  u1c0.b = 0;	/* LSB first, CMOS, buffered, f1 */
  u1c1.b = 5;	/* enable tx, rx */

  pinsr1.b = 0x05; /* P3_7, P4_5 */
  pmr.u1pinsel = 1;
  pmr.txd1sel = 1;

  s1ric = 5;

  wait_ms (1);
}

void
tty_putc (char c)
{
  int i;
  if (c == '\n')
    tty_putc ('\r');
  while (!u1c1.ti)
    asm("wait");
  for (i=0; i<500; i++)
    asm("nop");
  u1tb = c;
}

void
tty_puts (char *s)
{
  while (*s)
    {
      tty_putc (*s);
      s++;
    }
}

void
tty_write (void *data, int len)
{
  char *d = (char *)data;
  while (len--)
    tty_putc (*d++);
}

write (int fd, void *data, int len)
{
  tty_write (data, len);
  return len;
}

/* returns number of characters available */
int
tty_ready (void)
{
  return bufc;
}

/* returns character */
int
tty_readc (void)
{
  int rv;
  while (bufc == 0)
    ;
  rv = buf[bufg&15];
  bufg++;
  asm("fclr I");
  bufc--;
  if (bufc < 4)
    START();
  asm("fset I");
  return rv;
}

#if 0
/* returns number of characters read */
int
tty_read (void *data, int len)
{
}
#endif
