#include "bsp.h"

unsigned volatile int tics = 0;
unsigned volatile long tics_long = 0;

void __attribute__((interrupt))
timer_ra_handler ()
{
  tics ++;
  tics_long ++;
  traic = 5;
}

static void __attribute__((constructor))
timer_A_initialize ()
{
  tracr.b = 0;
  traioc.b = 0;
  tramr.b = 0;
#ifdef CLOCK_125KHz
  trapre = 0;
  tra = 124;
#else
  trapre = (CLOCK_HZ / 100000) - 1;
  tra = 100-1;
#endif
  traic = 5;
  tracr.tstart = 1;
}

int
wait_ms (int ms)
{
  int now = tics;
  while ((int)(tics - now) < ms)
    ;
}
