#include "bsp.h"
#include "spi.h"

static void __attribute__((constructor))
spi_initialize ()
{
  ssmr2.b = 0;

  sser.te = 0;     /* transmitter disabled */
  sser.re = 0;     /* receiver disabled */
  ssmr2.ssums = 1; /* 4-wire mode */
  ssmr.cphs = 0;   /* change data at odd edge */
  ssmr.cpos = 1;   /* clock polarity - L when idle */
  ssmr.mls = 0;    /* msb first */
  sscrh.mss = 1;   /* operate as master */
  ssmr2.scks = 1;  /* SCK is clock */
  ssmr2.soos = 0;  /* SSO pin is CMOS */

  sscrh.cks = 6;   /* f1/4 */
  //sscrh.cks = 0;   /* f1/256 */

  sscrh.rsstp = 0; /* multi-byte receive enabled */
  sssr.orer = 0;   /* no overrun errors */
  sser.re = 1;     /* transmitter enabled */
  sser.te = 1;     /* receiver enabled */
  sser.rie = 0;    /* no receive interrupts */
  sser.teie = 0;   /* no transmit end interrupt */
  sser.tie = 0;    /* no transmit interrupt */
}

void
spi_reset (void)
{
  asm("nop");
}
