typedef unsigned char byte;

typedef unsigned short word;


typedef union {
  struct {
    byte b0:1;
    byte b1:1;
    byte b2:1;
    byte b3:1;
    byte b4:1;
    byte b5:1;
    byte b6:1;
    byte b7:1;
  };
  byte b;
} pd0_type;
#define pd0 (*(volatile pd0_type *)0xe2)

typedef union {
  struct {
    byte b0:1;
    byte b1:1;
    byte b2:1;
    byte b3:1;
    byte b4:1;
    byte b5:1;
    byte b6:1;
    byte b7:1;
  };
  byte b;
} pd1_type;
#define pd1 (*(volatile pd1_type *)0xe3)

typedef union {
  struct {
    byte b0:1;
    byte b1:1;
    byte b2:1;
    byte b3:1;
    byte b4:1;
    byte b5:1;
    byte b6:1;
    byte b7:1;
  };
  byte b;
} pd3_type;
#define pd3 (*(volatile pd3_type *)0xe7)

typedef union {
  struct {
    byte b0:1;
    byte b1:1;
    byte b2:1;
    byte b3:1;
    byte b4:1;
    byte b5:1;
    byte b6:1;
    byte b7:1;
  };
  byte b;
} pd4_type;
#define pd4 (*(volatile pd4_type *)0xea)

typedef union {
  struct {
    byte b0:1;
    byte b1:1;
    byte b2:1;
    byte b3:1;
    byte b4:1;
    byte b5:1;
    byte b6:1;
    byte b7:1;
  };
  byte b;
} pd5_type;
#define pd5 (*(volatile pd5_type *)0xeb)

typedef union {
  struct {
    byte b0:1;
    byte b1:1;
    byte b2:1;
    byte b3:1;
    byte b4:1;
    byte b5:1;
    byte b6:1;
    byte b7:1;
  };
  byte b;
} p0_type;
#define p0 (*(volatile p0_type *)0xe0)

typedef union {
  struct {
    byte b0:1;
    byte b1:1;
    byte b2:1;
    byte b3:1;
    byte b4:1;
    byte b5:1;
    byte b6:1;
    byte b7:1;
  };
  byte b;
} p1_type;
#define p1 (*(volatile p1_type *)0xe1)

typedef union {
  struct {
    byte b0:1;
    byte b1:1;
    byte b2:1;
    byte b3:1;
    byte b4:1;
    byte b5:1;
    byte b6:1;
    byte b7:1;
  };
  byte b;
} p3_type;
#define p3 (*(volatile p3_type *)0xe5)

typedef union {
  struct {
    byte b0:1;
    byte b1:1;
    byte b2:1;
    byte b3:1;
    byte b4:1;
    byte b5:1;
    byte b6:1;
    byte b7:1;
  };
  byte b;
} p4_type;
#define p4 (*(volatile p4_type *)0xe8)

typedef union {
  struct {
    byte b0:1;
    byte b1:1;
    byte b2:1;
    byte b3:1;
    byte b4:1;
    byte b5:1;
    byte b6:1;
    byte b7:1;
  };
  byte b;
} p5_type;
#define p5 (*(volatile p5_type *)0xe9)

#define p1drr (*(volatile byte *)0xfe)

typedef union {
  struct {
    byte prc0:1;
    byte prc1:1;
    byte prc2:1;
    byte prc3:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
  };
  byte b;
} prcr_type;
#define prcr (*(volatile prcr_type *)0x0a)

typedef union {
  struct {
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte pm03:1;
    byte unspec_3:1;
    byte unspec_4:1;
    byte unspec_5:1;
    byte unspec_6:1;
  };
  byte b;
} pm0_type;
#define pm0 (*(volatile pm0_type *)0x04)

typedef union {
  struct {
    byte unspec_0:1;
    byte unspec_1:1;
    byte pm12:1;
    byte unspec_2:1;
    byte unspec_3:1;
    byte unspec_4:1;
    byte unspec_5:1;
    byte unspec_6:1;
  };
  byte b;
} pm1_type;
#define pm1 (*(volatile pm1_type *)0x05)

#define cm0 (*(volatile byte *)0x06)
#define cm1 (*(volatile byte *)0x07)
#define ocd (*(volatile byte *)0x0c)

typedef union {
  struct {
    byte cks:4;
    byte trs:1;
    byte mst:1;
    byte rcvd:1;
    byte ice:1;
  };
  byte b;
} iccr1_type;
#define iccr1 (*(volatile iccr1_type *)0xb8)

typedef union {
  struct {
    byte unspec_0:1;
    byte iicrst:1;
    byte unspec_1:1;
    byte sclo:1;
    byte sdaop:1;
    byte sdao:1;
    byte scp:1;
    byte bbsy:1;
  };
  byte b;
} iccr2_type;
#define iccr2 (*(volatile iccr2_type *)0xb9)

typedef union {
  struct {
    byte bc:3;
    byte bcwp:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte wait:1;
    byte mls:1;
  };
  byte b;
} icmr_type;
#define icmr (*(volatile icmr_type *)0xba)

typedef union {
  struct {
    byte ackbt:1;
    byte ackbr:1;
    byte acke:1;
    byte stie:1;
    byte makie:1;
    byte rie:1;
    byte teit:1;
    byte tie:1;
  };
  byte b;
} icier_type;
#define icier (*(volatile icier_type *)0xbb)

typedef union {
  struct {
    byte adz:1;
    byte aas:1;
    byte al:1;
    byte stop:1;
    byte nackf:1;
    byte rdrf:1;
    byte tend:1;
    byte tdre:1;
  };
  byte b;
} icsr_type;
#define icsr (*(volatile icsr_type *)0xbc)

typedef union {
  struct {
    byte fsb:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
    byte unspec_4:1;
    byte unspec_5:1;
    byte unspec_6:1;
  };
  byte b;
} sar_type;
#define sar (*(volatile sar_type *)0xbd)

#define icdrt (*(volatile byte *)0xbe)
#define icdrr (*(volatile byte *)0xbf)

typedef union {
  struct {
    byte uart1sel:2;
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
    byte unspec_4:1;
    byte unspec_5:1;
  };
  byte b;
} pinsr1_type;
#define pinsr1 (*(volatile pinsr1_type *)0xf5)

typedef union {
  struct {
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
    byte unspec_4:1;
    byte unspec_5:1;
    byte trb0sel0:1;
    byte unspec_6:1;
  };
  byte b;
} pinsr2_type;
#define pinsr2 (*(volatile pinsr2_type *)0xf6)

typedef union {
  struct {
    byte unspec_0:1;
    byte unspec_1:1;
    byte trciocsel:1;
    byte trciodsel:1;
    byte unspec_2:1;
    byte unspec_3:1;
    byte unspec_4:1;
  };
  byte b;
} pinsr3_type;
#define pinsr3 (*(volatile pinsr3_type *)0xf7)

typedef union {
  struct {
    byte int1sel:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte ssisel:1;
    byte u1pinsel:1;
    byte txd1sel:1;
    byte txd1en:1;
    byte iicsel:1;
  };
  byte b;
} pmr_type;
#define pmr (*(volatile pmr_type *)0xf8)

typedef union {
  struct {
    byte int0en:1;
    byte int0pl:1;
    byte int1en:1;
    byte int1pl:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte int3en:1;
    byte int3pl:1;
  };
  byte b;
} inten_type;
#define inten (*(volatile inten_type *)0xf9)

typedef union {
  struct {
    byte int0f:2;
    byte int1f:2;
    byte unspec_0:1;
    byte unspec_1:1;
    byte int3f:2;
  };
  byte b;
} intf_type;
#define intf (*(volatile intf_type *)0xfa)

#define kupic (*(volatile byte *)0x4d)
#define adic (*(volatile byte *)0x4e)
#define ssuaic (*(volatile byte *)0x4f)
#define iic2aic (*(volatile byte *)0x4f)
#define cmp1ic (*(volatile byte *)0x50)
#define s0tic (*(volatile byte *)0x51)
#define s1tic (*(volatile byte *)0x53)
#define s0ric (*(volatile byte *)0x52)
#define s1ric (*(volatile byte *)0x54)
#define txic (*(volatile byte *)0x56)
#define traic (*(volatile byte *)0x56)
#define tzic (*(volatile byte *)0x58)
#define trbic (*(volatile byte *)0x58)
#define int1ic (*(volatile byte *)0x59)
#define int3ic (*(volatile byte *)0x5a)
#define tcic (*(volatile byte *)0x5b)
#define cmp0ic (*(volatile byte *)0x5c)
#define int0ic (*(volatile byte *)0x5d)

typedef union {
  struct {
    byte smd:3;
    byte ckdir:1;
    byte stps:1;
    byte pry:1;
    byte prye:1;
    byte unspec_0:1;
  };
  byte b;
} u0mr_type;
#define u0mr (*(volatile u0mr_type *)0xa0)

#define u0brg (*(volatile byte *)0xa1)
#define u0tb (*(volatile byte *)0xa2)

typedef union {
  struct {
    byte clk:2;
    byte unspec_0:1;
    byte txept:1;
    byte unspec_1:1;
    byte nch:1;
    byte ckpol:1;
    byte uform:1;
  };
  byte b;
} u0c0_type;
#define u0c0 (*(volatile u0c0_type *)0xa4)

typedef union {
  struct {
    byte te:1;
    byte ti:1;
    byte re:1;
    byte ri:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
  };
  byte b;
} u0c1_type;
#define u0c1 (*(volatile u0c1_type *)0xa5)

#define u0rb (*(volatile word *)0xa6)

typedef union {
  struct {
    byte smd:3;
    byte ckdir:1;
    byte stps:1;
    byte pry:1;
    byte prye:1;
    byte unspec_0:1;
  };
  byte b;
} u1mr_type;
#define u1mr (*(volatile u1mr_type *)0xa8)

#define u1brg (*(volatile byte *)0xa9)
#define u1tb (*(volatile byte *)0xaa)

typedef union {
  struct {
    byte clk:2;
    byte unspec_0:1;
    byte txept:1;
    byte unspec_1:1;
    byte nch:1;
    byte ckpol:1;
    byte uform:1;
  };
  byte b;
} u1c0_type;
#define u1c0 (*(volatile u1c0_type *)0xac)

typedef union {
  struct {
    byte te:1;
    byte ti:1;
    byte re:1;
    byte ri:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
  };
  byte b;
} u1c1_type;
#define u1c1 (*(volatile u1c1_type *)0xad)

#define u1rb (*(volatile word *)0xae)
#define u1sr (*(volatile byte *)0xf5)

typedef union {
  struct {
    byte u0irs:1;
    byte u1irs:1;
    byte u0rrm:1;
    byte unspec_0:1;
    byte u1sel:2;
    byte unspec_1:1;
    byte cntrsel:1;
  };
  byte b;
} ucon_type;
#define ucon (*(volatile ucon_type *)0xb0)

typedef union {
  struct {
    byte txmod:2;
    byte r0edg:1;
    byte txs:1;
    byte txocnt:1;
    byte txmod2:1;
    byte txedg:1;
    byte txund:1;
  };
  byte b;
} txmr_type;
#define txmr (*(volatile txmr_type *)0x8b)

#define prex (*(volatile byte *)0x8c)
#define tx (*(volatile byte *)0x8d)

typedef union {
  struct {
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
    byte tzmod:2;
    byte tzwc:1;
    byte tzs:1;
  };
  byte b;
} tzmr_type;
#define tzmr (*(volatile tzmr_type *)0x80)

typedef union {
  struct {
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
    byte tzopl:1;
    byte inostg:1;
    byte inosec:1;
  };
  byte b;
} pum_type;
#define pum (*(volatile pum_type *)0x84)

#define prez (*(volatile byte *)0x85)
#define tzsc (*(volatile byte *)0x86)
#define tzpr (*(volatile byte *)0x87)

typedef union {
  struct {
    byte tzos:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
    byte unspec_4:1;
    byte unspec_5:1;
    byte unspec_6:1;
  };
  byte b;
} tzoc_type;
#define tzoc (*(volatile tzoc_type *)0x8a)

typedef union {
  struct {
    byte txck:2;
    byte unspec_0:1;
    byte unspec_1:1;
    byte tzck:2;
    byte unspec_2:1;
    byte unspec_3:1;
  };
  byte b;
} tcss_type;
#define tcss (*(volatile tcss_type *)0x8e)

typedef union {
  struct {
    byte tstart:1;
    byte tcstr:1;
    byte tstop:1;
    byte unspec_0:1;
    byte tedgf:1;
    byte tundf:1;
    byte unspec_1:1;
    byte unspec_2:1;
  };
  byte b;
} tracr_type;
#define tracr (*(volatile tracr_type *)0x100)

typedef union {
  struct {
    byte tedgsel:1;
    byte topcr:1;
    byte toena:1;
    byte tiosel:1;
    byte tipf:2;
    byte unspec_0:1;
    byte unspec_1:1;
  };
  byte b;
} traioc_type;
#define traioc (*(volatile traioc_type *)0x101)

typedef union {
  struct {
    byte tmod:3;
    byte unspec_0:1;
    byte tck:3;
    byte tckcut:1;
  };
  byte b;
} tramr_type;
#define tramr (*(volatile tramr_type *)0x102)

#define trapre (*(volatile byte *)0x103)
#define tra (*(volatile byte *)0x104)

typedef union {
  struct {
    byte tstart:1;
    byte tcstr:1;
    byte tstop:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
    byte unspec_4:1;
  };
  byte b;
} trbcr_type;
#define trbcr (*(volatile trbcr_type *)0x108)

typedef union {
  struct {
    byte tosst:1;
    byte tossp:1;
    byte tosstf:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
    byte unspec_4:1;
  };
  byte b;
} trbocr_type;
#define trbocr (*(volatile trbocr_type *)0x109)

typedef union {
  struct {
    byte topl:1;
    byte tocnt:1;
    byte inostg:1;
    byte inoseg:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
  };
  byte b;
} trbioc_type;
#define trbioc (*(volatile trbioc_type *)0x10a)

typedef union {
  struct {
    byte tmod:2;
    byte unspec_0:1;
    byte twrc:1;
    byte tck:2;
    byte unspec_1:1;
    byte tckcut:1;
  };
  byte b;
} trbmr_type;
#define trbmr (*(volatile trbmr_type *)0x10b)

#define trbpre (*(volatile byte *)0x10c)
#define trbsc (*(volatile byte *)0x10d)
#define trbpr (*(volatile byte *)0x10e)
#define tc (*(volatile word *)0x90)
#define tm0 (*(volatile word *)0x9c)
#define tm1 (*(volatile word *)0x9e)

typedef union {
  struct {
    byte tc0sb:1;
    byte tc0ssb:2;
    byte tc0icp:2;
    byte unspec_0:1;
    byte tc0int3:1;
    byte tc0iisb:1;
  };
  byte b;
} tcc0_type;
#define tcc0 (*(volatile tcc0_type *)0x9a)

typedef union {
  struct {
    byte tc1if:2;
    byte tc1rs:1;
    byte tc10csb:1;
    byte tc11oms:2;
    byte tc10oms:2;
  };
  byte b;
} tcc1_type;
#define tcc1 (*(volatile tcc1_type *)0x9b)

#define tcout (*(volatile byte *)0xff)

typedef union {
  struct {
    byte ch:3;
    byte md:1;
    byte adgsel0:1;
    byte unspec_0:1;
    byte adst:1;
    byte cks0:1;
  };
  byte b;
} adcon0_type;
#define adcon0 (*(volatile adcon0_type *)0xd6)

typedef union {
  struct {
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte bits:1;
    byte cks1:1;
    byte vcut:1;
    byte unspec_3:1;
    byte unspec_4:1;
  };
  byte b;
} adcon1_type;
#define adcon1 (*(volatile adcon1_type *)0xd7)

typedef union {
  struct {
    byte smp:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte unspec_3:1;
    byte unspec_4:1;
    byte unspec_5:1;
    byte unspec_6:1;
    byte unspec_7:1;
  };
  byte b;
} adcon2_type;
#define adcon2 (*(volatile adcon2_type *)0xd4)

#define ad (*(volatile word *)0xc0)
#define ad8 (*(volatile byte *)0xc0)

typedef union {
  struct {
    byte cks:3;
    byte unspec_0:1;
    byte unspec_1:1;
    byte mss:1;
    byte rsstp:1;
    byte unspec_2:1;
  };
  byte b;
} sscrh_type;
#define sscrh (*(volatile sscrh_type *)0xb8)

typedef union {
  struct {
    byte unspec_0:1;
    byte sres:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte solp:1;
    byte sol:1;
    byte unspec_3:1;
    byte unspec_4:1;
  };
  byte b;
} sscrl_type;
#define sscrl (*(volatile sscrl_type *)0xb9)

typedef union {
  struct {
    byte bc:3;
    byte unspec_0:1;
    byte unspec_1:1;
    byte cphs:1;
    byte cpos:1;
    byte mls:1;
  };
  byte b;
} ssmr_type;
#define ssmr (*(volatile ssmr_type *)0xba)

typedef union {
  struct {
    byte ceie:1;
    byte unspec_0:1;
    byte unspec_1:1;
    byte re:1;
    byte te:1;
    byte rie:1;
    byte teie:1;
    byte tie:1;
  };
  byte b;
} sser_type;
#define sser (*(volatile sser_type *)0xbb)

typedef union {
  struct {
    byte ce:1;
    byte unspec_0:1;
    byte orer:1;
    byte unspec_1:1;
    byte unspec_2:1;
    byte rdrf:1;
    byte tend:1;
    byte tdre:1;
  };
  byte b;
} sssr_type;
#define sssr (*(volatile sssr_type *)0xbc)

typedef union {
  struct {
    byte ssums:1;
    byte csos:1;
    byte soos:1;
    byte sckos:1;
    byte css:2;
    byte scks:1;
    byte bide:1;
  };
  byte b;
} ssmr2_type;
#define ssmr2 (*(volatile ssmr2_type *)0xbd)

#define sstdr (*(volatile byte *)0xbe)
#define ssrdr (*(volatile byte *)0xbf)
#define ivec_brk 0
#define ivec_timer_rc 7
#define ivec_timer_re 10
#define ivec_key 13
#define ivec_adc 14
#define ivec_iic 15
#define ivec_s0tx 17
#define ivec_s0rx 18
#define ivec_s1tx 19
#define ivec_s1rx 20
#define ivec_timer_ra 22
#define ivec_timer_rb 24
#define ivec_int1 25
#define ivec_int3 26
#define ivec_int0 29

#define set_ivect(f,n) \
  asm ("mov.w #%%lo16(%d0),_ivects+%d1"   : : "s" (f), "g" (n*4)); \
  asm ("mov.w #%%hi16(%d0),_ivects+%d1" : : "s" (f), "g" (n*4+2));
