#include "pmclock.h"
.include "r8c27.inc"

	.section ".vec", "a"
	.3byte	0	; UND
	.byte	0xff
	.3byte	0	; overflow
	.byte	0xff
	.3byte	0	; BRK, see also ivect
	.byte	0xff

	.rept	20
	.byte	0xff
	.endr

	.section ".resetvec", "a"
	.global	_reset
_reset:
	.3byte	_start
	.byte	0xff		; watchdog settings.

	.text
	.global _start
_start:
	fclr	I
	fclr	U	/* Interrupt stack gets the big main stack.  */
	ldc	#__stack,sp
; We're going to use a combined stack, because we're running low on memory.
;	fset	U	/* User stack gets the little one. */
;	ldc	#__istack,sp

	ldc	#%lo16(_ivects),intbl
	ldc	#%hi16(_ivects),intbh

; Copy ROM data to RAM
	mov.b	#%hi8(__romdatastart),r1h
	mov.w	#%lo16(__romdatastart),a0
	mov.w	#__datastart,a1
	mov.w	#__romdatacopysize,r3
	shl.w	#-1,r3
	smovf.w

	mov.w	#__bssstart,a1
	mov.w	#__bsssize,r3
	shl.w	#-1,r3
	mov.w	#0,r0
	sstr.w

	;; You must set ONE of these two clock-setting source blocks
	;; to ".if 1" if you want a fast clock.  If you leave them
	;; both ".if 0" you get the 125 kHz clock.

#ifdef CLOCK_12MHz
; Fire up the external (crystal/xin) clock (USB, 12 MHz)
	mov.b	#0x01, prcr
	mov.b	#0x08, cm0
	mov.b	#0x38, cm1
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	mov.b	#0x00, ocd
	mov.b	#0x08, cm0
	mov.b	#0x00, prcr
#endif

#ifdef CLOCK_20MHz
; Fire up the high-speed internal clock (~20 MHz)
	mov.b	#0x01, prcr
	mov.b	#0x08, cm0
	mov.b	#0x38, cm1
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	mov.b	#0x05, ocd
	mov.b	#0x08, cm0
	mov.b	#0x00, prcr
#endif

	fset	I

; Run any function marked as a "contructor"

	mov.w	#__init_array_start, a1
1:	cmp.w	#__init_array_end, a1
	jeq	1f
	push.w	a1
	mov.w	[a1], a0
	mov.b	#0,a1
	jsri.a	a1a0
	pop.w	a1
	add.w	#2, a1
	jmp.b	1b
1:	

; Run the main application

	jmp.w	_main

	.global __reset
__reset:
	.global __exit
__exit:
	bset	$prc1, prcr
	bset	$pm03, pm0
	jmp.b	__exit

	.bss
;	.global	__impure_ptr
;__impure_ptr:
;	.space	10
	.global	mem0
mem0:	.space	1
	.global	mem1
mem1:	.space	1
	.global	mem2
mem2:	.space	1
	.global	mem3
mem3:	.space	1
	.global	mem4
mem4:	.space	1
	.global	mem5
mem5:	.space	1
	.global	mem6
mem6:	.space	1
	.global	mem7
mem7:	.space	1
	.global	mem8
mem8:	.space	1
	.global	mem9
mem9:	.space	1
	.global	mem10
mem10:	.space	1
	.global	mem11
mem11:	.space	1
	.global	mem12
mem12:	.space	1
	.global	mem13
mem13:	.space	1
	.global	mem14
mem14:	.space	1
	.global	mem15
mem15:	.space	1

