#include "r8c27.h"
#include "pmclock.h"

#define nLED p6.b3

typedef void (*ifunc)() __attribute__((mode(SI)));
extern ifunc ivects[64];

extern void exit (int rv);

#ifdef CLOCK_12MHz
#define CLOCK_HZ 12000000
#endif
#ifdef CLOCK_20MHz
#define CLOCK_HZ 20000000
#endif
#ifdef CLOCK_125KHz
#define CLOCK_HZ 125000
#endif

#ifndef CLOCK_HZ
#error Set one of the clock speeds in clock.h
#endif

extern unsigned char reverse_byte[256];

/*#define printf iprintf*/

#define swaps(x) (((x)<<8) | ((x)>>8))

/* These are based on a 1000 Hz internal timer.  */
extern volatile unsigned int  tics;
extern volatile unsigned long tics_long;
/* This is based on a 60 Hz zero crossing interrupt. */
extern volatile unsigned long uptime_seconds;
