#!/bin/perl5
# -*- perl -*-
# Copyright 1998 DJ Delorie <dj@delorie.com>
# Distributed under the terms of the GNU General Public License

require "./bugtools.pl";

$bug = shift;
$bug = $in{'bug'} unless $bug;
$bug = sprintf("%06d", $bug);

if ( ! -f "db/$bug/info" ) {
    &error("Bug $bug doesn't exist");
}

&header("Bug $bug");

$hr = "<hr noshade size=1>";

open(INFO, "db/$bug/info");
while (<INFO>) {
    s/[\r\n]+$//;
    ($tag, $rest) = split(' ', $_, 2);
    $date = &dt($rest);

    if ($tag eq "create") {
	($date, $ver) = split(' ', $rest);
	$date = &dt($date);
	print "When Created: $date<br>\n";
	print "Against DJGPP version: $ver<br>\n";

    } elsif ($tag eq "note") {
	print "${hr}Note added: $date<br>\n";

    } elsif ($tag eq "workaround") {
	print "${hr}Workaround added: $date<br>\n";

    } elsif ($tag eq "solution") {
	print "${hr}Solution added: $date<br>\n";

    } elsif ($tag eq "fixed") {
	($date, $ver) = split(' ', $rest);
	$date = &dt($date);
	print "${hr}Fixed in version $ver on $date<br>\n";

    } elsif ($tag eq "closed") {
	($date, $why) = split(' ', $rest, 2);
	$date = &dt($date);
	print "${hr}Closed on $date: $why<br>\n";

    } elsif ($tag eq "email") {
	print "By whom:<tt> <a href=\"mailto:$rest\">$rest</a></tt><br>\n";

    } elsif ($tag eq "abstract") {
	print "Abstract: <b>$rest</b><br>\n";

    } elsif ($tag eq "version") {
	print "Found in version $rest<br>\n";

    } elsif ($tag eq "description") {
	print "<small><pre>";
	open(D, "db/$bug/$rest");
	while (<D>) {
	    s/\&/\&amp;/g;
	    s/\</\&lt;/g;
	    s/\>/\&gt;/g;
	    s@(http://[a-zA-Z0-9._:/\?=\&\%\+-]+)@<a href="$1">$1</a>@g;
	    print;
	}
	close(D);
	print "</pre></small>";

    }
}

&adorn($bug);

&trailer();
