#!/bin/perl5
# -*- perl -*-
# Copyright 1998 DJ Delorie <dj@delorie.com>
# Distributed under the terms of the GNU General Public License

require "./bugtools.pl";

if ($ENV{'REQUEST_METHOD'} =~ /post/i) {

    $in{'email'} =~ s/[\r\n\s\t]+/ /g;
    $in{'reason'} =~ s/[\r\n\s\t]+/ /g;
    $bug = sprintf("%06d", $in{'bug'});

    &valid_email($in{'email'});

    if ($bug !~ /\S/) {
	&error("You must provide a bug number.");
    }

    if (! -f "db/$bug/info") {
	&error("Bug $bug doesn't exist.");
    }

    if ($in{'version'} !~ /\S/) {
	&error("You must provide a version.");
    }

    &header("Mark $upper as Fixed");

    open(INFO, ">>db/$bug/info");
    print INFO "\n";
    print INFO "fixed $nowdate $in{'reason'}\n";
    print INFO "email $in{'email'}\n";
    close(INFO);

    print "<p>You have fixed bug\n";
    print "<a href=\"show.cgi?$bug\"><tt>$bug</tt></a>.</p>\n";

    &log("Closed $bug $in{'reason'} <$in{'email'}>");

    &trailer();
}

$bug = shift;
$bug = $in{'bug'} unless $bug;
$bug = sprintf("%06d", $bug);

&header("Mark Bug $bug as Fixed");

$versions = `./version.pl`;

print <<EOF;

<form method="POST" action="fixed.cgi">

<p>E-mail address: <input type=text name=email size=40 value="$email">

<p>Bug Number: <input type=text name=bug size=20 value="$bug">

<p>What version was it fixed in? $versions

<p><input type=submit value="Mark Bug Fixed">

</form>

EOF

&trailer();

1;
