#!/bin/perl5
# -*- perl -*-
# Copyright 1998 DJ Delorie <dj@delorie.com>
# Distributed under the terms of the GNU General Public License

require "./bugtools.pl";

if ($ENV{'REQUEST_METHOD'} =~ /post/i) {
    $in{'email'} =~ s/[\r\n\s\t]+/ /g;
    $in{'abstract'} =~ s/[\r\n\s\t]+/ /g;
    $in{'version'} =~ s/[\r\n\s\t]+/ /g;

    &valid_email($in{'email'});

    if ($in{'abstract'} !~ /\S/) {
	&error("You must provide an abstract.");
    }

    if ($in{'version'} !~ /\S/) {
	&error("You must select a version.");
    }

    if ($in{'description'} !~ /\S/) {
	&error("You must provide a description of the bug.");
    }

    &header("Bug Creation");

    open(IDX, "db/bug.idx");
    flock(IDX, 2);
    $x = <IDX>;
    $x =~ s/[\r\n]+$//;
    while (1) {
	$x = sprintf("%06d", 0 + $x);
	last unless -d "db/$x/.";
	$x ++;
    }
    mkdir("db/$x", 0755);
    close(IDX);
    open(IDX, ">db/bug.idx");
    printf IDX "%06d", $x+1;
    close(IDX);

    open(INFO, ">db/$x/info");
    print INFO "create $nowdate $in{'version'}\n";
    print INFO "email $in{'email'}\n";
    print INFO "abstract $in{'abstract'}\n";
    print INFO "description $nowdate.desc\n";
    close(INFO);

    open(DESC, ">db/$x/$nowdate.desc");
    $in{'description'} =~ s/\r\n/\n/g;
    $in{'description'} =~ s/\r/\n/g;
    print DESC $in{'description'};
    close(DESC);

    print "<p>You have created bug<tt> <a href=\"show.cgi?$x\">$x</a></tt></p>\n";

    &log("Create $x:$in{'version'} $in{'abstract'} <$in{'email'}>");
    print LOG $in{'description'}, "\n";

    &trailer();
}

&header("Report a Bug");

$versions = `./version.pl`;

print <<EOF;

Please make sure you have checked the <a href="list-fixed.cgi">fixed
bug list</a> and the <a href="list-open.cgi">open bug list</a> before
creating a new bug, in case someone else has already reported this
bug. <p>

<p>If you haven't already, please discuss this bug in the main newsgroup
before creating it here.  Many bugs are not bugs at all, or have already
been fixed.</p>

<form method="POST" action="create.cgi">

<p>E-mail address: <input type=text name=email size=60 value="$email">

<p>Enter a one-line abstract of the problem below.<br>
<input type=text name=abstract size=80>

<p>What version did you see this bug in? $versions

<p>Enter a description of the problem below.  You will have an
opportunity to append a workaround or solution later.<br>
<textarea name=description rows=20 cols=80></textarea><p>

<p><big><b>Before submitting this form, ask yourself - did you ask
this question in comp.os.msdos.djgpp or djgpp\@delorie.com first?  If
not, why not?  You should do that, and wait for an answer, before
using this form.</b></big></p>

<input type=submit value="Create New Bug Report">

</form>

EOF

&trailer();
