#!/bin/perl5
# -*- perl -*-
# Copyright 1998 DJ Delorie <dj@delorie.com>
# Distributed under the terms of the GNU General Public License

push(@INC, split(':', $ENV{'PATH'}));
require "cgi-lib.pl";
&ReadParse();

for $cookie (split(/[; ]+/, $ENV{'HTTP_COOKIE'})) {
    ($key, $value) = split('=', $cookie, 2);
    $cookie{$key} = $value;
}

($t_sec, $t_min, $t_hour, $t_day, $t_mon, $t_year, $t_week) = localtime;
$t_mon++;
$t_year += 2000 if $t_year < 60;
$t_year += 1900 if $t_year < 200;

if ($in{'email'}) {
    $email = $in{'email'};
    $email =~ s/[\r\n\s\t]+//g;
    printf("Set-Cookie: email=%s; path=/; expires=%s %02d-%s-%04d %02d:%02d:%02d GMT\n",
	   $email, substr("SunMonTueWedThuFriSat", $t_week*3, 3),
	   $t_day, substr("   JanFebMarAprMayJunJulAugSepOctNovDec", $t_mon*3, 3),
	   $t_year+1, $t_hour, $t_minute, $t_sec);
} else {
    $email = $cookie{'email'};
}

$nowdate = sprintf("%04d-%02d-%02d-%02d-%02d-%02d",
		   $t_year, $t_mon, $t_day, $t_hour, $t_min, $t_sec);

sub error {
    &header("Error");
    print "<p>$_[0]</p>\n";
    &trailer();
}

sub header {
    print "Content-type: text/html\n\n";
    print `header "$_[0]"`;
}

sub trailer {
    print `trailer`;
    exit 0;
}

sub enumerate_bugs {
    local(@rv) = ();
    opendir(D, "db");
    while ($d = readdir(D)) {
	push(@rv, $d) if $d =~ /^\d\d\d\d\d\d$/ && -f "db/$d/info";
    }
    closedir(D);
    return reverse sort @rv;
}

sub load_bug {
    local($bug) = @_;
    return if $loaded{$bug};
    $loaded{$bug} = 1;
    open(INFO, "db/$bug/info");
    while (<INFO>) {
	s/[\r\n]+$//;
	($tag, $rest) = split(' ', $_, 2);
	next unless $tag;
	$info{"$bug $tag"} .= "\0" if $info{"$bug $tag"};
	$info{"$bug $tag"} .= $rest;
	$info{"$bug tags"} .= "\0" if $info{"$bug tags"};
	$info{"$bug tags"} .= $tag;
    }
    close(INFO);
}

sub row {
    local($bug, $state, $ver) = @_;

    $date = $info{"$bug $state"};
    $date = $info{"$bug create"} unless $date;
    $date =~ s/ .*//;
    ($y,$m,$d,$hour,$min,$sec) = split('-', $date);
    if ($y == $t_year && $m == $t_mon && $d == $t_day) {
	$date = "$hour:$min";
    } elsif ($y == $t_year) {
	$date = "$m/$d";
    } else {
	$date = $y;
    }

    print "<tr valign=top>\n";
    print "<td align=center><small><a href=\"show.cgi?$bug\"><tt>$bug</tt></a><br>$ver</small></td>\n";
    print "<td align=center><small>$state<br>$date</small></td>\n";
    print "<td align=center valign=center><small><tt>";
    print "N" if $info{"$bug note"};
    print "W" if $info{"$bug workaround"};
    print "S" if $info{"$bug solution"};
    print "F" if $info{"$bug fixed"};
    print "C" if $info{"$bug closed"};
    print "<br>&nbsp;</tt></small></td>\n";
    $ab = $info{"$bug abstract"};
    print "<td><tt>&nbsp;</tt></td>";
    print "<td>$ab<tt>  </tt><small><tt>\n";
    print "</td></tr>\n";
}

sub dt {
    local ($yy, $mm, $dd, $h, $m, $s) = split('-', $_[0]);

    return "$mm/$dd/$yy $h:$m:$s";
}

sub adorn {
    local($bug) = @_;
    &load_bug($bug);
    print "<p><hr noshade size=1><ul>\n";
    print "<li><a href=\"note.cgi?$bug\">Add a note</a>\n";
    print "<li><a href=\"workaround.cgi?$bug\">Add a workaround</a>\n";
    print "<li><a href=\"solution.cgi?$bug\">Add a solution</a>\n";
    if ($info{"$bug solution"} && ! $info{"$bug fixed"}) {
	print "<li><a href=\"fixed.cgi?$bug\">Mark it as fixed</a> (and close it)\n";
    }
    if (($info{"$bug note"} || $info{"$bug workaround"})
	&& ! $info{"$bug closed"}) {
	print "<li><a href=\"closed.cgi?$bug\">Close without fixing</a> (i.e. will never be fixed)\n";
    }
    print "</ul>\n";
}

sub valid_email {
    local($email) = @_;

    if ($in{'email'} !~ /(\S+)\@(\S+\.\S+)/) {
	&error("You must provide a valid email address.");
	return;
    }

    ($u,$h) = ($1,$2);
    if (gethostbyname($h)) {
	return;
    }

    open(NS, "nslookup -type=MX '$h' |");
    local ($ok) = 0;
    while (<NS>) {
	if (/preference/i) {
	    $ok = 1;
	}
    }
    close(NS);
    return if $ok;

    &error("You must provide a valid email address.");
}

$log_open = 0;

sub log {
    if (! $log_open) {
	open(LOG, ">>db/log");
	$log_open = 1;
	$log_time = &dt($nowdate);
	print LOG "\n";
    }
    print LOG "$log_time: $_[0]\n";
}

1;
