#!/bin/perl5
# -*- perl -*-
# Copyright 1998 DJ Delorie <dj@delorie.com>
# Distributed under the terms of the GNU General Public License

require "./bugtools.pl";

if ($ENV{'REQUEST_METHOD'} =~ /post/i) {
    &header("Bug $upper Submittal");


    $in{'email'} =~ s/[\r\n\s\t]+/ /g;
    $bug = sprintf("%06d", $in{'bug'});

    &valid_email($in{'email'});

    if ($bug !~ /\S/) {
	&error("You must provide a bug number.");
    }

    if (! -f "db/$bug/info") {
	&error("Bug $bug doesn't exist.");
    }

    if ($in{'description'} !~ /\S/) {
	&error("You must provide a description of the bug.");
    }

    open(INFO, ">>db/$bug/info");
    print INFO "\n";
    print INFO "$lower $nowdate\n";
    print INFO "email $in{'email'}\n";
    print INFO "description $nowdate.$ext\n";
    close(INFO);

    open(DESC, ">db/$bug/$nowdate.$ext");
    $in{'description'} =~ s/\r\n/\n/g;
    $in{'description'} =~ s/\r/\n/g;
    print DESC $in{'description'};
    close(DESC);

    print "<p>You have added a $lower to bug\n";
    print "<a href=\"show.cgi?$bug\"><tt>$bug</tt></a>.</p>\n";

    &log("$upper $bug <$in{'email'}>");
    print LOG $in{'description'}, "\n";

    &trailer();
}

&header("Bug $upper Submittal");

$bug = shift;
$bug = $in{'bug'} unless $bug;
$bug = sprintf("%06d", $bug);

print <<EOF;

<form method="POST" action="$lower.cgi">

E-mail address: <input type=text name=email size=40 value="$email"><p>

Bug Number: <input type=text name=bug size=20 value="$bug"><p>

Enter a $lower for the problem below.<br>
<textarea name=description rows=20 cols=80></textarea><p>

<input type=submit value="Submit">

</form>

EOF

&trailer();

1;
